using System;
using LFS_External;
using LFS_External.InSim;

namespace LFS_External_Client
{
	/// <summary>
	/// Information of a player on the track or in the pits
	/// </summary>
	public class clsPlayer
    {
        #region raceInfo
        protected int _currlap = 0;
        public int currentLap
        {
            get { return _currlap; }
            set { _currlap = value; }
        }

        protected byte _currpos = 0;
        public byte currentPosition
        {
            get { return _currpos; }
            set { _currpos = value; }
        }
        #endregion

        protected byte _playerid = 0;
		protected byte _uniqueid = 0;
		protected enuPType _ptype = (enuPType)(0);
		protected Flags.PlayerFlags _flags = (Flags.PlayerFlags)(0);
		protected string _playername = "_undetected";
        protected string _plate = "_undetected";
        protected string _carname = "-";
        protected string _skinname = "-";
		protected Enums.NPL_Tyres _tyre_rl = Enums.NPL_Tyres.TYRE_NUM;
        protected Enums.NPL_Tyres _tyre_rr = Enums.NPL_Tyres.TYRE_NUM;
        protected Enums.NPL_Tyres _tyre_fl = Enums.NPL_Tyres.TYRE_NUM;
        protected Enums.NPL_Tyres _tyre_fr = Enums.NPL_Tyres.TYRE_NUM;
		protected byte _addedmass = 0;
		protected byte _intakerestriction = 0;
		protected byte _passengers = 0;

		public enum enuPType : byte
		{
			Female = 0,
			AI = 1,
			Remote = 2,
        }

        protected bool _safspecinvinc = false;
        public bool safSpecInvinc
        {
            get { return _safspecinvinc; }
            set { _safspecinvinc = value; }
        }

        public Packets.CompCar CompCar = new Packets.CompCar
        {
            AngVel = 0,
            Direction = 0,
            Heading = 0,
            Info = (Flags.CompCarFlags)(0),
            Lap = 0,
            Node = 0,
            PLID = 0,
            Position = 0,
            Speed = 0,
            X = 0,
            Y = 0,
            Z = 0
        };
        public Packets.CompCar CompCarPrev = new Packets.CompCar
        {
            AngVel = 0,
            Direction = 0,
            Heading = 0,
            Info = (Flags.CompCarFlags)(0),
            Lap = 0,
            Node = 0,
            PLID = 0,
            Position = 0,
            Speed = 0,
            X = 0,
            Y = 0,
            Z = 0
        };

		/// <summary>Unique player id</summary>
		public byte PlayerID
		{
			get { return _playerid; }
			set { _playerid = value; }
		}

		/// <summary>This player belogns to this connection (changes on Driver Swap)</summary>
		public byte UniqueID
		{
			get { return _uniqueid; }
			set { _uniqueid = value; }
		}

		/// <summary>Type of player</summary>
		public enuPType PlayerType
		{
			get { return _ptype; }
			set { _ptype = value; }
		}

		/// <summary>Flags, Packet.PIF_xxx</summary>
		public Flags.PlayerFlags Flags
		{
			get { return _flags; }
			set { _flags = value; }
		}

		/// <summary>Players ingame name</summary>
		public string PlayerName
		{
			get { return _playername; }
			set { _playername = value; }
		}

		/// <summary>Plate of car</summary>
		public string Plate
		{
			get { return _plate; }
			set { _plate = value; }
		}

		/// <summary>Current players car</summary>
		public string CarName
		{
			get { return _carname; }
			set { _carname = value; }
		}

		/// <summary>Name of the skin on the car</summary>
		public string SkinName
		{
			get { return _skinname; }
			set { _skinname = value; }
		}

		/// <summary>Rear Left tyre type</summary>
		public Enums.NPL_Tyres Tyre_RL
		{
			get { return _tyre_rl; }
			set { _tyre_rl = value; }
		}

		/// <summary>Rear Right tyre type</summary>
		public Enums.NPL_Tyres Tyre_RR
		{
			get { return _tyre_rr; }
			set { _tyre_rr = value; }
		}

		/// <summary>Front Left tyre type</summary>
		public Enums.NPL_Tyres Tyre_FL
		{
			get { return _tyre_fl; }
			set { _tyre_fl = value; }
		}

		/// <summary>Front Right tyre type</summary>
		public Enums.NPL_Tyres Tyre_FR
		{
			get { return _tyre_fr; }
			set { _tyre_fr = value; }
		}

		/// <summary>Extra mass in Kg</summary>
		public byte AddedMass
		{
			get { return _addedmass; }
			set { _addedmass = value; }
		}

		/// <summary>Passanger in the car</summary>
		public byte Passengers
		{
			get { return _passengers; }
			set { _passengers = value; }
		}

		/// <summary>Intake Restriction</summary>
		public byte IntakeRestriction
		{
			get { return _intakerestriction; }
			set { _intakerestriction = value; }
		}
	}
}
